"use strict";

exports.__esModule = true;
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Parser = _interopRequireDefault(require("./Parser"));

var _Markup = _interopRequireDefault(require("./Markup"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Interweave = function (_React$PureComponent) {
  _inheritsLoose(Interweave, _React$PureComponent);

  function Interweave() {
    return _React$PureComponent.apply(this, arguments) || this;
  }

  var _proto = Interweave.prototype;

  _proto.parseMarkup = function parseMarkup() {
    var _this = this;

    var _ref = this.props,
        content = _ref.content,
        disableFilters = _ref.disableFilters,
        disableMatchers = _ref.disableMatchers,
        emptyContent = _ref.emptyContent,
        filters = _ref.filters,
        matchers = _ref.matchers,
        onAfterParse = _ref.onAfterParse,
        onBeforeParse = _ref.onBeforeParse,
        tagName = _ref.tagName,
        props = _objectWithoutPropertiesLoose(_ref, ["content", "disableFilters", "disableMatchers", "emptyContent", "filters", "matchers", "onAfterParse", "onBeforeParse", "tagName"]);

    var allMatchers = disableMatchers ? [] : matchers;
    var allFilters = disableFilters ? [] : filters;
    var beforeCallbacks = onBeforeParse ? [onBeforeParse] : [];
    var afterCallbacks = onAfterParse ? [onAfterParse] : [];
    allMatchers.forEach(function (matcher) {
      if (matcher.onBeforeParse) {
        beforeCallbacks.push(matcher.onBeforeParse.bind(matcher));
      }

      if (matcher.onAfterParse) {
        afterCallbacks.push(matcher.onAfterParse.bind(matcher));
      }
    });
    var markup = beforeCallbacks.reduce(function (string, callback) {
      var nextString = callback(string, _this.props);

      if ("production" !== process.env.NODE_ENV) {
        if (typeof nextString !== 'string') {
          throw new TypeError('Interweave `onBeforeParse` must return a valid HTML string.');
        }
      }

      return nextString;
    }, content || '');
    var parser = new _Parser.default(markup, props, allMatchers, allFilters);
    var nodes = afterCallbacks.reduce(function (parserNodes, callback) {
      var nextNodes = callback(parserNodes, _this.props);

      if ("production" !== process.env.NODE_ENV) {
        if (!Array.isArray(nextNodes)) {
          throw new TypeError('Interweave `onAfterParse` must return an array of strings and React elements.');
        }
      }

      return nextNodes;
    }, parser.parse());

    if (nodes.length === 0) {
      return emptyContent;
    }

    return nodes;
  };

  _proto.render = function render() {
    var _this$props = this.props,
        emptyContent = _this$props.emptyContent,
        tagName = _this$props.tagName;
    return _react.default.createElement(_Markup.default, {
      emptyContent: emptyContent,
      tagName: tagName,
      parsedContent: this.parseMarkup()
    });
  };

  return Interweave;
}(_react.default.PureComponent);

exports.default = Interweave;

_defineProperty(Interweave, "propTypes", {
  disableFilters: _propTypes.default.bool,
  disableMatchers: _propTypes.default.bool,
  filters: _propTypes.default.arrayOf(_propTypes.default.any),
  matchers: _propTypes.default.arrayOf(_propTypes.default.any),
  onAfterParse: _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.oneOf([null])]),
  onBeforeParse: _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.oneOf([null])])
});

_defineProperty(Interweave, "defaultProps", {
  content: '',
  disableFilters: false,
  disableMatchers: false,
  emptyContent: null,
  filters: [],
  matchers: [],
  onAfterParse: null,
  onBeforeParse: null,
  tagName: 'span'
});